//===============================================================================================
// Disable the enter key and backspace accelerator keys based on the element type that 
// fired the event.
//
// To use, you must add the following line to the document.onload event handler:
//			document.body.onkeypress=disableAccelerators;
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

function disableAccelerators()
{
	document.onkeydown = _disableAccelerators;
	document.ondragstart = _disableDrag; // disable drag drop
	
	// take the body out of the tab order
	if( document.body) document.body.tabIndex = -1;
}

function _disableAccelerators()
{
	var evt=window.event;
	if(!evt)return;
	
	var bCancel = false;
	var tag, btn;
	
	// Disable carriage return except in textareas (don't support select)
	// and links...which sends a mouse click event
	if( 13==evt.keyCode )
	{
		bCancel = true;
		if( evt.srcElement && evt.srcElement.tagName )
		{		
			tag = evt.srcElement.tagName.toLowerCase();
			if( "textarea" == tag ) bCancel = false;
			else if( "a" == tag )
			{
				if( evt.srcElement.onclick ) evt.srcElement.fireEvent( "onclick" );
				else bCancel = false;
			}	
			else if( "select" == tag ) bCancel = false;
			else if( "input" == tag && "button" == evt.srcElement.type ) bCancel = false;
		}
		
		if( bCancel )
		{
			// Check if the continue button is present, if so simulate a click
			if( window.onAnswerNext )
			{
				btn = document.getElementById("next");
				if( btn ) window.onAnswerNext( btn.id );				
			}
		}		
	}	
	// Disable backspace except in textareas and input text boxes
	else if( 8==evt.keyCode )
	{
		bCancel = true;
		if( evt.srcElement && evt.srcElement.tagName )
		{
			tag = evt.srcElement.tagName.toLowerCase();
			if( "input" == tag )
			{
				var tp=evt.srcElement.type;
				if( "text"==tp || "password"==tp ) bCancel = false; 
			}
			else if( "textarea" == tag ) bCancel = false;
		}	
		
		if( bCancel )
		{
			// Check if the back button is present, if so simulate a click
			if( window.onAnswerNext )
			{
				btn = document.getElementById("back");
				if( btn ) window.onAnswerNext( btn.id );				
			}
			else if( window.goBack ) window.goBack();
		}				
	}
	// Space key on links and buttons behaves like the enter key
	else if( 32 == evt.keyCode )
	{
		if( evt.srcElement && evt.srcElement.tagName )
		{
			tag = evt.srcElement.tagName.toLowerCase();
			if( "a" == tag )
			{
				if( evt.srcElement.onclick ) evt.srcElement.fireEvent( "onclick" );
				else evt.keyCode = 13;
			}	
			else if( "input" == tag && "button" == evt.srcElement.type ) evt.keyCode = 13;
		}		
	}	
	
	if( bCancel )
	{
		evt.cancelBubble = true;
		evt.returnValue = false;
	}
}

function _disableDrag()
{
	var evt=window.event;
	if(!evt)return;

	evt.cancelBubble = true;
	evt.returnValue = false;
}
